Option Explicit

Const scriptName = "Creator 6 Prefs Extractor"
Const scriptVer = "1.0.0"

'This VBScript was written to export Creator's preferences.
'Copyright (C) 2005 Michael Miller

'Redistribution and use in source and binary forms, with or without
'modification, are permitted provided that the following conditions are met:

'Redistributions of source code must retain the above copyright notice,
'this list of conditions and the following disclaimer.
'Redistributions in binary form must reproduce the above copyright notice,
'this list of conditions and the following disclaimer in the documentation
'and/or other materials provided with the distribution.
'The name of the author may not be used to endorse or promote products
'derived from this software without specific prior written permission.

'THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
'IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
'OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
'IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
'INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
'NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
'DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
'THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
'(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
'THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.



Const errNoFile = "To use this script, drop an agent data text file onto this script."

'Const qSourceFolder = "Please select the agent data text file:"
Const qDestFolder = "Please select the destination folder:"
Const qDestFilename = "Save Creator Preferences as:"

Const msgComplete = "Done!"

Const kHeaders = "Windows Registry Editor Version 5.00"

' Search for ~Foo "bar"
Const kCreatorRegKey="HKEY_CURRENT_USER\Software\MultiAd\MultiAd Creator"
Const kSectionHeaderCheck="HKEY_CURRENT_USER\\Software\\MultiAd\\MultiAd Creator"

Const kSectionDeleteCount = 3
Dim sectionDeleteList(3)
sectionDeleteList(0) = kSectionHeaderCheck & "\\BarState"
sectionDeleteList(1) = kSectionHeaderCheck & "\\Recent File List"
sectionDeleteList(2) = kSectionHeaderCheck & "\\Settings"

Const kDeleteCount=7
Dim deleteList(7)
deleteList(0) = "^""PosX"
deleteList(1) = "^""PosY"
deleteList(2) = "^""LastPath"
deleteList(3) = "^""LastPanel"
deleteList(4) = "^""UserName"
deleteList(5) = "^""BorderPath"
deleteList(6) = "^""BorderSubDir"


Const kSubDirChar = "\"
Const kDefaultDestDir = "."
Const kDefaultFileName = "Creator Preferences.reg"
'kDefaultFileName = MakeDefaultFileName

Dim kGeneratorComment
kGeneratorComment = "; Created by " & scriptName & " " & scriptVer & " on " & Date

'enum iomode for FileSystemObject
Const ForReading = 1
Const ForWriting = 2
Const ForAppending = 8

'enum format for FileSystemObject
Const OpenAsDefault = -2
Const OpenAsUnicode = -1
Const OpenAsASCII = 0


' Global RegEexes
Dim regHeader
Set regHeader = New RegExp
regHeader.Pattern = kSectionHeaderCheck
regHeader.IgnoreCase = True


' Global Objects:
Dim fso
Set fso = CreateObject("Scripting.FileSystemObject")
Dim wsh
Set wsh = CreateObject("WScript.Shell")

Main


Function MakeDefaultFileName()
	Dim returnMe
	returnMe = ""
	Dim theDate, theYear, theMonth
	theDate = Now
	theYear = Year(theDate)
	theMonth = Month(theDate)
	If (theMonth = 1) Then
		theYear = theYear - 1
		theMonth = 12
	Else
		theMonth = theMonth - 1
	End If
	returnMe = returnMe & theYear
	returnMe = returnMe & "-"
	if (theMonth < 10) then returnMe = returnMe & "0"
	returnMe = returnMe & theMonth & " Agents.csv"
	
	MakeDefaultFileName = returnMe
End Function

Function BrowseForFolder(ByRef dialogText)
	Dim returnMe
	returnMe = ""

	Dim options
	options = &H0001 + &H0008 +  &H0050
	
	Dim shellObj
	Set shellObj = WScript.CreateObject("Shell.Application")

	Dim folderObj, oFolderItem
	On Error Resume Next
	Err.Clear
	Set folderObj = shellObj.BrowseForFolder(0, dialogText, options)
	Set oFolderItem = folderObj.Items.Item
	
	returnMe = oFolderItem.Path
	If (Err.Number <> 0) Then
	  returnMe = ""
	End If
	On Error Goto 0

	BrowseForFolder = returnMe
End Function


Private Function GetWorkingDirectory()
  Dim returnMe
  returnMe = WScript.ScriptFullName

  Set returnMe = fso.GetFile(returnMe)
  Set GetWorkingDirectory = returnMe.ParentFolder
End Function


' This just tests the pattern on the text without returning matches.
Private Function TestMatch(pattern, theText, ignoreCase)
   Dim regEx,  returnMe
   returnMe = False
   
   Set regEx = New RegExp
   regEx.Pattern = pattern
   regEx.IgnoreCase = ignoreCase
   'regEx.Global = True
   
   TestMatch = regEx.Test(theText)
End Function


' This runs a regular expression on some text and returns the first
' match group
Private Function GetMatch(pattern, theText, ignoreCase)
   Dim regEx, matchList, returnMe
   returnMe = ""
   
   Set regEx = New RegExp
   regEx.Pattern = pattern
   regEx.IgnoreCase = ignoreCase
   'regEx.Global = True
   
   If regEx.Test(theText) Then
     Set matchList = regEx.Execute(theText)   ' Execute search.
     If (matchList.Count = 1) Then
       returnMe = matchList(0).Submatches(0)
     End If
   End If

   GetMatch = returnMe
End Function

Private Function MatchesLineToSkip(ByRef lineString)
	Dim returnMe, i
	returnMe = False

	For i = 0 to (kDeleteCount-1)
		If TestMatch(deleteList(i), lineString, True) Then
			returnMe = True
			Exit For
		End If
	Next

	MatchesLineToSkip = returnMe
End Function


Private Function MatchesHeaderToSkip(ByRef headerString)
	Dim returnMe, i
	returnMe = False

	For i = 0 to (kSectionDeleteCount-1)
		If TestMatch(sectionDeleteList(i), headerString, True) Then
			returnMe = True
			Exit For
		End If
	Next

	MatchesHeaderToSkip = returnMe
End Function


Private Function DoLine(ByRef sourceStream, ByRef destStream)
	Dim returnMe
	returnMe = False

	Dim isHeader, thisLine, subHeader
    thisLine = sourceStream.ReadLine

	If (regHeader.Test(thisLine)) Then
		If MatchesHeaderToSkip(thisLine) Then
			Do Until (thisLine = "" Or sourceStream.AtEndOfStream)
				thisLine = sourceStream.ReadLine
			Loop
		Else		
			destStream.WriteLine(thisLine)
		End If
	ElseIf Not (MatchesLineToSkip(thisLine)) Then
		destStream.WriteLine(thisLine)
	End If

	DoLine = returnMe  
End Function


' takes the passed-in text and creates a smaller file from it
Private Function PrunePrefs(ByRef sourceStream, ByRef destStream)
    Dim returnMe
    returnMe = True
    
    'destStream.WriteLine(kHeaders)
   
    Dim matched
    Do While Not sourceStream.AtEndOfStream
      matched = DoLine(sourceStream, destStream)
    Loop

	destStream.WriteLine(kGeneratorComment)
    
    sourceStream.Close
    destStream.Close

    PrunePrefs = returnMe
End Function


Private Sub DeleteTempFile
	' Get the Temp folder.  Wipe out our temp file.
	Dim tempPath, procEnv
	Set procEnv = wsh.Environment("PROCESS")
	tempPath = procEnv("TEMP")
	If Right(tempPath,1) <> kSubDirChar Then tempPath = tempPath & kSubDirChar
	tempPath = tempPath & "temppref.reg"
	fso.GetFile(tempPath).Delete
End Sub

Private Function AskForSource(ByRef sourceStream)
	Dim continueOn
	continueOn = False

	' Get the Temp folder.  Write the file to it.
	Dim tempPath, procEnv
	Set procEnv = wsh.Environment("PROCESS")
	tempPath = procEnv("TEMP")
	
	If (tempPath <> "") Then
		If Right(tempPath,1) <> kSubDirChar Then tempPath = tempPath & kSubDirChar
		'tempPath = "c:\"
		tempPath = tempPath & "temppref.reg"
		Dim shellExec
		Set shellExec = wsh.Exec("regedit /e """ & tempPath & """ """ & kCreatorRegKey & """")

		Do While shellExec.Status = 0
			WScript.Sleep 100
		Loop

		Do While (Not shellExec.StdOut.AtEndOfStream)
			WScript.Echo(shellExec.StdOut.ReadLine)
		Loop
		Do While (Not shellExec.StdErr.AtEndOfStream)
			WScript.Echo(shellExec.StdErr.ReadLine)
		Loop
		

		Dim sourceFile
		Set sourceFile = fso.GetFile(tempPath)
        Set sourceStream = sourceFile.OpenAsTextStream(ForReading, OpenAsDefault)
		continueOn = True
	End If

	AskForSource = continueOn
End Function


Private Function AskForDestination(ByRef destDir, ByRef destStream)
	Dim continueOn
	continueOn = True

	Dim tempPath, tempName
	If IsEmpty(destDir) Or IsNull(destDir) Then
		tempPath = BrowseForFolder(qDestFolder)
		If (tempPath <> "") Then
			Set destDir = fso.GetFolder(tempPath)
		Else
			continueOn = False
		End If
	End If
	
	'Set destStream = destDir.CreateTextFile(kDefaultFileName, True, False)
	If continueOn Then
		tempName = InputBox(qDestFilename, scriptName, kDefaultFileName)
		If (tempName <> "") Then
			Set destStream = destDir.CreateTextFile(tempName, True, False)
		Else
			continueOn = False
		End If
	End If

	AskForDestination = continueOn
End Function



Private Function InterpretCommandLine(ByRef inputFile)
    inputFile = ""

    Dim continueOn
    continueOn = True

    Dim i, args, thisSwitch, thisValue
    Set args = WScript.Arguments
    If (args.Count = 0) Then
		continueOn = False
    ElseIf (args.Count <> 1) Then
        continueOn = False
    Else
		inputFile = args(0)
    End If

    InterpretCommandLine = continueOn
End Function


Public Sub Main

  Dim continueOn, createdFile
  Dim inputFile
  continueOn = InterpretCommandLine(inputFile)
  createdFile = False
  

  Dim sourceStream, destStream, destDir

  If continueOn Then
    Dim destFile

    Dim sourceFile
    Set sourceFile = fso.GetFile(inputFile)
    Set sourceStream = sourceFile.OpenAsTextStream(ForReading, OpenAsDefault)

    Set destDir = sourceFile.ParentFolder
    
    continueOn = AskForDestination(destDir, destStream)
  Else
    ' Ask the user for everything:
	createdFile = True
    continueOn = AskForSource(sourceStream)
	Set destDir = fso.GetFolder(wsh.SpecialFolders("Desktop"))
    If continueOn Then continueOn = AskForDestination(destDir, destStream)
  End If

  If continueOn Then
    continueOn = PrunePrefs(sourceStream, destStream)
	If createdFile Then DeleteTempFile
	
	WScript.Echo(msgComplete)
  Else
    'WScript.Echo(errNoFile)
  End If
  
End Sub
